<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateUsersTable extends Migration {

	public function up()
	{
		Schema::create('users', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->softDeletes();
			$table->string('name', 255);
			$table->string('country_key');
			$table->string('phone');
			$table->string('lat');
			$table->string('lng');
			$table->text('map_desc');
			$table->string('commerical_image');
			$table->string('password');
			$table->enum('type', array(''));
			$table->string('avatar', 255)->default('default.png');
			$table->string('logo', 255)->nullable();
			$table->text('bio')->nullable();
			$table->double('wallet', 0,0);
			$table->string('lang', 10);
			$table->string('email', 100);
			$table->integer('gender')->default('0');
			$table->date('birthdate');
			$table->string('nationality', 150);
			$table->string('organization_name', 150)->nullable();
		});
	}

	public function down()
	{
		Schema::drop('users');
	}
}