<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateTimingsTable extends Migration {

	public function up()
	{
		Schema::create('timings', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->string('day', 50);
			$table->time('from');
			$table->time('to');
			$table->boolean('is_closed')->default(0);
			$table->integer('branch_id')->unsigned();
		});
	}

	public function down()
	{
		Schema::drop('timings');
	}
}