<?php

namespace App;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class ProductVariantsMapModel extends Model 
{

    protected $table = 'product_variants_map';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];

    public function product()
    {
        return $this->belongsTo('App\ProductsModel', 'product_id');
    }

    public function size()
    {
        return $this->belongsTo('App\VariantValuesModel', 'variant_value_size_id');
    }

    public function color()
    {
        return $this->belongsTo('App\VariantValuesModel', 'variant_value_color_id');
    }

    public function unit()
    {
        return $this->belongsTo('App\UnitsModel', 'unit_id');
    }

}