<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateProductVariantsMapTable extends Migration {

	public function up()
	{
		Schema::create('product_variants_map', function(Blueprint $table) {
			$table->increments('id');
			$table->integer('product_id')->unsigned()->index();
			$table->string('product_sku')->nullable();
			$table->integer('variant_value_size_id')->nullable();
			$table->integer('variant_value_color_id')->nullable();
			$table->float('manufacturing_cost', 8,2)->default('0');
			$table->float('supplier_cost', 8,2)->default('0.00');
			$table->enum('track_quantity', array('Yes', 'No'))->nullable();
			$table->integer('unit_id')->unsigned()->index();
			$table->string('quantity')->nullable();
			$table->enum('status', array('Active', 'Inactive'))->nullable();
			$table->timestamps();
			$table->softDeletes();
		});
	}

	public function down()
	{
		Schema::drop('product_variants_map');
	}
}