<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateOrdersTable extends Migration {

	public function up()
	{
		Schema::create('orders', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->softDeletes();
			$table->integer('address_id')->unsigned()->nullable();
			$table->integer('user_id')->unsigned();
			$table->longText('notes')->nullable();
			$table->integer('pay_type')->nullable()->default('0');
			$table->decimal('area')->nullable()->default('0');
			$table->boolean('know_problem')->nullable()->default(0);
			$table->decimal('expected_price')->nullable();
			$table->decimal('price')->nullable();
			$table->string('service_name')->nullable();
			$table->integer('type')->nullable()->default('0');
			$table->integer('status')->nullable()->default('0');
			$table->integer('provider_id')->unsigned()->nullable();
			$table->integer('category_id')->unsigned()->nullable();
			$table->integer('sub_category_id')->unsigned();
			$table->integer('city_id')->unsigned();
			$table->boolean('have_invoice')->nullable()->default(0);
		});
	}

	public function down()
	{
		Schema::drop('orders');
	}
}