<?php

namespace Api;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Comment extends Model 
{

    protected $table = 'comment';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $fillable = array('post_id', 'message', 'created_by', 'reply_on', 'main_thread');

    public function comment()
    {
        return $this->belongsTo('Comment', 'reply_on');
    }

    public function comments()
    {
        return $this->hasMany('Comment', 'reply_on');
    }

    public function main_comment()
    {
        return $this->belongsTo('Comment', 'main_thread');
    }

    public function client()
    {
        return $this->belongsTo('User', 'created_by');
    }

    public function post()
    {
        return $this->belongsTo('Post', 'post_id');
    }

    public function reactions()
    {
        return $this->hasMany('CommentReaction', 'comment_id');
    }

    public function reports()
    {
        return $this->hasMany('CommentReport', 'comment_id');
    }

}