<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateTblSettingCityPortTable extends Migration {

	public function up()
	{
		Schema::create('tbl_setting_city_port', function(Blueprint $table) {
			$table->increments('city_port_id', true);
			$table->string('city_port_code');
			$table->string('city_port_name', 100);
			$table->text('city_port_description')->nullable();
			$table->integer('country_id')->unsigned();
			$table->enum('city_port_status', array('Active', 'Inactive'));
			$table->timestamp('city_port_updated');
			$table->timestamps();
			$table->timestamps()->nullable();
		});
	}

	public function down()
	{
		Schema::drop('tbl_setting_city_port');
	}
}