<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateTblSettingParticularCategoryTable extends Migration {

	public function up()
	{
		Schema::create('tbl_setting_particular_category', function(Blueprint $table) {
			$table->increments('particular_category_id', true);
			$table->integer('particular_category_priority');
			$table->string('particular_category_name', 100);
			$table->enum('particular_category_status', array('Active', 'Inactive'));
			$table->text('particular_category_description')->nullable();
			$table->datetime('particular_category_created');
			$table->datetime('particular_category_updated');
			$table->datetime('particular_category_deleted')->nullable();
		});
	}

	public function down()
	{
		Schema::drop('tbl_setting_particular_category');
	}
}