<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateTblVesselEquipmentTable extends Migration {

	public function up()
	{
		Schema::create('tbl_vessel_equipment', function(Blueprint $table) {
			$table->increments('vessel_equipment_id', true);
			$table->integer('vessel_equipment_type_id')->unsigned();
			$table->integer('equipment_id')->unsigned();
			$table->string('vessel_equipment_name', 100);
			$table->json('vessel_equipment_value');
			$table->integer('vessel_equipment_quantity');
			$table->text('vessel_equipment_remark')->nullable();
			$table->datetime('vessel_equipment_created');
			$table->timestamp('vessel_equipment_updated');
		});
	}

	public function down()
	{
		Schema::drop('tbl_vessel_equipment');
	}
}