<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateUserProfileTable extends Migration {

	public function up()
	{
		Schema::create('user_profile', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->bigInteger('user_id')->unsigned();
			$table->string('designation');
			$table->string('purpose_to_use_app');
			$table->date('dob')->nullable();
			$table->string('addres1')->nullable();
			$table->string('addres2');
			$table->string('city')->nullable();
			$table->string('state')->nullable();
			$table->integer('zip')->nullable();
			$table->string('country');
			$table->string('title')->nullable();
			$table->string('emaployment_type')->nullable();
			$table->string('company_name')->nullable();
			$table->string('location_of_company')->nullable();
			$table->string('empolyment_mode')->nullable();
			$table->text('start_date')->nullable();
			$table->boolean('currently_working_here')->nullable();
			$table->string('description', 2000)->nullable();
			$table->text('end_date')->nullable();
			$table->string('bio')->nullable();
		});
	}

	public function down()
	{
		Schema::drop('user_profile');
	}
}