<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateClientsTable extends Migration {

	public function up()
	{
		Schema::create('clients', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->integer('phone');
			$table->string('password');
			$table->string('name');
			$table->string('email');
			$table->date('date_of_birth');
			$table->date('last_donation_date');
			$table->integer('blood_type_id')->unsigned();
			$table->integer('city_id');
			$table->integer('pin_code');
		});
	}

	public function down()
	{
		Schema::drop('clients');
	}
}