<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateUsersTable extends Migration {

	public function up()
	{
		Schema::create('users', function(Blueprint $table) {
			$table->increments('id');
			$table->string('phone_number');
			$table->string('name');
			$table->string('email');
			$table->string('otp');
			$table->string('profile_pic_url');
			$table->string('username');
			$table->string('address')->nullable();
			$table->timestamps();
			$table->softDeletes();
			$table->bigInteger('country_id')->unsigned()->nullable();
			$table->bigInteger('city_id')->unsigned()->nullable();
			$table->bigInteger('state_id')->unsigned()->nullable();
			$table->float('balance')->nullable();
		});
	}

	public function down()
	{
		Schema::drop('users');
	}
}