<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateTasksTable extends Migration {

	public function up()
	{
		Schema::create('tasks', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->softDeletes();
			$table->longText('task_description');
			$table->date('execution_date');
			$table->enum('task_status', array(''Expired'', ''Canceled'', ''Missed'', ''InProgress''));
			$table->enum('assignee', array('manager', 'employee'));
			$table->bigInteger('employee_id')->unsigned();
		});
	}

	public function down()
	{
		Schema::drop('tasks');
	}
}