<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateProgramsTable extends Migration {

	public function up()
	{
		Schema::create('programs', function(Blueprint $table) {
			$table->bigIncrements('idProgram');
			$table->string('name', 200);
			$table->string('code', 50)->nullable();
			$table->string('abbreviation', 50)->nullable();
			$table->boolean('apply_inscriptions')->default(true);
			$table->tinyInteger('evaluation_type')->nullable()->default('0');
			$table->string('resolution_number', 200)->nullable();
			$table->date('resolution_date')->nullable();
			$table->boolean('apply_groups')->nullable()->default(true);
			$table->tinyInteger('state')->nullable()->default('1');
			$table->string('version', 50)->nullable();
			$table->string('TENANTID', 60)->nullable();
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('programs');
	}
}