<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateSubjectsTable extends Migration {

	public function up()
	{
		Schema::create('subjects', function(Blueprint $table) {
			$table->bigIncrements('idSubject');
			$table->string('name', 200)->nullable();
			$table->string('code', 50)->nullable();
			$table->string('version', 50)->nullable();
			$table->tinyInteger('state')->nullable()->default('1');
			$table->bigInteger('level_id')->nullable();
			$table->mediumInteger('credits')->nullable()->default('1');
			$table->mediumInteger('weekly_hi')->nullable();
			$table->mediumInteger('total_hi')->nullable();
			$table->string('TENANTID', 60)->nullable();
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('subjects');
	}
}