<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateSettingsTable extends Migration {

	public function up()
	{
		Schema::create('settings', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->string('rate_profit', 10)->nullable();
			$table->string('rate_fundrequest', 10);
			$table->integer('month_count');
			$table->integer('maximum_monthly_commitment');
			$table->string('rete_provider', 10);
			$table->integer('maximum_repayment_period');
			$table->integer('low_repayment_period');
			$table->string('maximum_purchase_amount', 10);
			$table->string('minimum_purchase_amount', 10);
			$table->string('profit_rate', 10);
			$table->string('maximum_amount', 10);
			$table->string('late_rate', 10);
			$table->string('employee_rate', 10);
			$table->string('install_rate', 10);
			$table->string('manager_rate', 10);
			$table->integer('start_install');
			$table->integer('end_install');
			$table->integer('latest_install');
		});
	}

	public function down()
	{
		Schema::drop('settings');
	}
}