<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateTicketsTable extends Migration {

	public function up()
	{
		Schema::create('tickets', function(Blueprint $table) {
			$table->increments('id');
			$table->integer('order_id');
			$table->integer('user_id');
			$table->integer('priority_id');
			$table->timestamp('last_replied_at')->nullable();
			$table->timestamp('last_seen_at')->nullable();
			$table->text('subject');
			$table->timestamps();
			$table->softDeletes();
		});
	}

	public function down()
	{
		Schema::drop('tickets');
	}
}