<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateForeignKeys extends Migration {

	public function up()
	{
		Schema::table('users', function(Blueprint $table) {
			$table->foreign('role_id')->references('id')->on('roles')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('ability_role', function(Blueprint $table) {
			$table->foreign('ability_id')->references('id')->on('abilities')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('ability_role', function(Blueprint $table) {
			$table->foreign('role_id')->references('id')->on('roles')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('ability_user', function(Blueprint $table) {
			$table->foreign('ability_id')->references('id')->on('abilities')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('ability_user', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('users')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('companies', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('users')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('cargo_firms_integration', function(Blueprint $table) {
			$table->foreign('company_id')->references('id')->on('cargo_firms')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('districts', function(Blueprint $table) {
			$table->foreign('city_id')->references('id')->on('cities')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('off_zones', function(Blueprint $table) {
			$table->foreign('cargo_firm_id')->references('id')->on('cargo_firms')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('off_zones', function(Blueprint $table) {
			$table->foreign('city_id')->references('id')->on('cities')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('off_zones', function(Blueprint $table) {
			$table->foreign('district_id')->references('id')->on('districts')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('orders', function(Blueprint $table) {
			$table->foreign('company_id')->references('id')->on('companies')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('order_barcodes', function(Blueprint $table) {
			$table->foreign('order_id')->references('id')->on('orders')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('order_items', function(Blueprint $table) {
			$table->foreign('order_id')->references('id')->on('orders')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('order_locations', function(Blueprint $table) {
			$table->foreign('order_id')->references('id')->on('orders')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('order_locations', function(Blueprint $table) {
			$table->foreign('city_id')->references('id')->on('cities')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('order_locations', function(Blueprint $table) {
			$table->foreign('district_id')->references('id')->on('districts')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('order_receivers', function(Blueprint $table) {
			$table->foreign('order_id')->references('id')->on('orders')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('order_requests', function(Blueprint $table) {
			$table->foreign('order_id')->references('id')->on('orders')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
	}

	public function down()
	{
		Schema::table('users', function(Blueprint $table) {
			$table->dropForeign('users_role_id_foreign');
		});
		Schema::table('ability_role', function(Blueprint $table) {
			$table->dropForeign('ability_role_ability_id_foreign');
		});
		Schema::table('ability_role', function(Blueprint $table) {
			$table->dropForeign('ability_role_role_id_foreign');
		});
		Schema::table('ability_user', function(Blueprint $table) {
			$table->dropForeign('ability_user_ability_id_foreign');
		});
		Schema::table('ability_user', function(Blueprint $table) {
			$table->dropForeign('ability_user_user_id_foreign');
		});
		Schema::table('companies', function(Blueprint $table) {
			$table->dropForeign('companies_user_id_foreign');
		});
		Schema::table('cargo_firms_integration', function(Blueprint $table) {
			$table->dropForeign('cargo_firms_integration_company_id_foreign');
		});
		Schema::table('districts', function(Blueprint $table) {
			$table->dropForeign('districts_city_id_foreign');
		});
		Schema::table('off_zones', function(Blueprint $table) {
			$table->dropForeign('off_zones_cargo_firm_id_foreign');
		});
		Schema::table('off_zones', function(Blueprint $table) {
			$table->dropForeign('off_zones_city_id_foreign');
		});
		Schema::table('off_zones', function(Blueprint $table) {
			$table->dropForeign('off_zones_district_id_foreign');
		});
		Schema::table('orders', function(Blueprint $table) {
			$table->dropForeign('orders_company_id_foreign');
		});
		Schema::table('order_barcodes', function(Blueprint $table) {
			$table->dropForeign('order_barcodes_order_id_foreign');
		});
		Schema::table('order_items', function(Blueprint $table) {
			$table->dropForeign('order_items_order_id_foreign');
		});
		Schema::table('order_locations', function(Blueprint $table) {
			$table->dropForeign('order_locations_order_id_foreign');
		});
		Schema::table('order_locations', function(Blueprint $table) {
			$table->dropForeign('order_locations_city_id_foreign');
		});
		Schema::table('order_locations', function(Blueprint $table) {
			$table->dropForeign('order_locations_district_id_foreign');
		});
		Schema::table('order_receivers', function(Blueprint $table) {
			$table->dropForeign('order_receivers_order_id_foreign');
		});
		Schema::table('order_requests', function(Blueprint $table) {
			$table->dropForeign('order_requests_order_id_foreign');
		});
	}
}