<?php

namespace App\Models;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class City extends Eloquent {

	protected $table = 'cities';
	public $timestamps = false;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('name', 'normalized_name');
	protected $visible = array('name', 'normalized_name');

	public function districts()
	{
		return $this->hasMany('App\Models\District');
	}

	public function offzones()
	{
		return $this->hasMany('App\Models\OffZone');
	}

	public function orderLocations()
	{
		return $this->hasMany('App\Models\Order\Location');
	}

	public function warehouses()
	{
		return $this->hasMany('App\Models\Company\Warehouse');
	}

}