<?php

namespace App\Models;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Company extends Eloquent {

	protected $table = 'companies';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('name', 'email', 'address', 'fax', 'mobile_phone_number', 'phone_number', 'tax_number', 'tax_office', 'logo', 'latitude', 'longitude');
	protected $visible = array('name', 'email', 'address', 'fax', 'mobile_phone_number', 'phone_number', 'latitude');

	public function owner()
	{
		return $this->belongsTo('App\Models\User');
	}

	public function cargoFirms()
	{
		return $this->hasMany('App\Models\Cargo\Firm');
	}

	public function documents()
	{
		return $this->morphMany('App\Models\Document');
	}

	public function warehouses()
	{
		return $this->hasMany('App\Models\Company\Warehouse');
	}

}