<?php

namespace App\Models\Deci;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Distribution extends Eloquent {

	protected $table = 'deci_distributions';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('deci_id', 'city_id');
	protected $visible = array('deci_id', 'city_id');

	public function deci()
	{
		return $this->belongsTo('App\Models\Deci');
	}

	public function city()
	{
		return $this->belongsTo('App\Models\City');
	}

	public function district()
	{
		return $this->belongsTo('App\Models\District');
	}

}