<?php

namespace App\Models\Cargo;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Firm extends Eloquent {

	protected $table = 'cargo_firms';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('name', 'website', 'phone_number');
	protected $visible = array('name', 'website', 'phone_number');

	public function integrations()
	{
		return $this->hasMany('Integration');
	}

	public function company()
	{
		return $this->belongsTo('App\Models\Company');
	}

}