<?php

namespace App\Models\Cargo;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Integration extends Eloquent {

	protected $table = 'cargo_firms_integration';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('type', 'is_system_defined', 'is_default');
	protected $visible = array('type', 'is_system_defined', 'is_default');

	public function company()
	{
		return $this->belongsTo('App\Models\Company');
	}

}