<?php

namespace App\Models\Order;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Request extends Eloquent {

	protected $table = 'order_requests';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('cargo_firm_integration_id', 'builder', 'resolver');
	protected $visible = array('cargo_firm_integration_id');

	public function order()
	{
		return $this->belongsTo('App\Models\Order');
	}

	public function cargoIntegration()
	{
		return $this->belongsTo('App\Models\Cargo\Integration', 'cargo_firm_integration_id');
	}

}