<?php

namespace App\Models\Order;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class RequestError extends Eloquent {

	protected $table = 'order_request_error';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('builder');
	protected $visible = array('builder');

	public function order()
	{
		return $this->belongsTo('App\Models\Order');
	}

	public function cargoIntegration()
	{
		return $this->belongsTo('App\Models\Cargo\Integration', 'cargo_firm_integration_id');
	}

}