<?php

namespace App\Models;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Role extends Eloquent {

	protected $table = 'roles';
	public $timestamps = false;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('name', 'description');
	protected $visible = array('name', 'description');

	public function abilities()
	{
		return $this->hasManyThrough('App\Models\Ability');
	}

}