<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateCompaniesTable extends Migration {

	public function up()
	{
		Schema::create('companies', function(Blueprint $table) {
			$table->increments('id');
			$table->bigInteger('user_id')->unsigned();
			$table->string('name');
			$table->string('email');
			$table->string('address');
			$table->string('fax')->nullable();
			$table->string('mobile_phone_number');
			$table->string('phone_number')->nullable();
			$table->string('tax_number');
			$table->string('tax_office')->nullable();
			$table->string('logo')->nullable();
			$table->string('latitude');
			$table->string('longitude')->nullable();
			$table->timestamps();
			$table->softDeletes();
		});
	}

	public function down()
	{
		Schema::drop('companies');
	}
}