<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateOrderItemsTable extends Migration {

	public function up()
	{
		Schema::create('order_items', function(Blueprint $table) {
			$table->increments('id');
			$table->bigInteger('order_id')->unsigned();
			$table->string('code');
			$table->string('status');
			$table->timestamp('delivered_at');
			$table->timestamp('completed_at');
			$table->timestamps();
			$table->softDeletes();
			$table->string('weight')->nullable();
			$table->string('width')->nullable();
			$table->string('height')->nullable();
			$table->string('length')->nullable();
		});
	}

	public function down()
	{
		Schema::drop('order_items');
	}
}