<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateOrderRequestErrorTable extends Migration {

	public function up()
	{
		Schema::create('order_request_error', function(Blueprint $table) {
			$table->increments('id');
			$table->integer('order_id');
			$table->string('cargo_firm_integration_id');
			$table->string('builder');
			$table->text('request');
			$table->string('resolver');
			$table->string('response')->nullable();
			$table->softDeletes();
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('order_request_error');
	}
}