<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateUsersTable extends Migration {

	public function up()
	{
		Schema::create('users', function(Blueprint $table) {
			$table->increments('id');
			$table->bigInteger('role_id')->unsigned();
			$table->string('first_name');
			$table->string('last_name');
			$table->string('email');
			$table->timestamp('email_verified_at')->nullable();
			$table->string('mobile_phone_number');
			$table->timestamp('mobile_phone_number_verified_at')->nullable();
			$table->timestamps();
			$table->softDeletes();
			$table->integer('company_id')->nullable();
		});
	}

	public function down()
	{
		Schema::drop('users');
	}
}