<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateSubscriptionsTable extends Migration {

	public function up()
	{
		Schema::create('subscriptions', function(Blueprint $table) {
			$table->increments('id');
			$table->bigInteger('user_id')->unsigned();
			$table->bigInteger('plan_id')->unsigned();
			$table->bigInteger('payment_gateway_id')->unsigned();
			$table->timestamp('ends_at');
			$table->string('type');
			$table->string('status', 20)->nullable();
			$table->string('paymet_subscription_id')->nullable();
			$table->string('payment_price_id');
			$table->timestamps();
			$table->timestamp('cancelled_at');
		});
	}

	public function down()
	{
		Schema::drop('subscriptions');
	}
}