<?php

namespace App/Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Order extends Model 
{

    protected $table = 'orders';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $fillable = array('order_no', 'mvikas_id', 'user_id', 'customer_id', 'billing_address', 'shipping_address', 'billing_gst_tin', 'shipping_gst_tin', 'note', 'term_and_conditions', 'created_on');
    protected $visible = array('order_no', 'mvikas_id', 'user_id', 'customer_id', 'billing_address', 'shipping_address', 'billing_gst_tin', 'shipping_gst_tin', 'note', 'term_and_conditions', 'created_on');

    public function customer()
    {
        return $this->belongsTo('Customer', 'customer_id', 'id');
    }

    public function mvikas()
    {
        return $this->belongsTo('Mvikas', 'mvikas', 'id');
    }

    public function user()
    {
        return $this->belongsTo('User', 'user_id', 'id');
    }

    public function documents()
    {
        return $this->morphMany('Document', 'documentable');
    }

    public function orders()
    {
        return $this->hasMany('OrderItems', 'order_id', 'id');
    }

    public function paymentTerm()
    {
        return $this->belongsTo('PaymentTerm', 'payment_id', 'id');
    }

}