<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreatePaymentTermsTable extends Migration {

	public function up()
	{
		Schema::create('payment_terms', function(Blueprint $table) {
			$table->increments('id');
			$table->bigInteger('parent_id')->unsigned()->index();
			$table->string('name');
			$table->string('slug')->unique();
			$table->boolean('status')->index()->default(1);
			$table->timestamps();
			$table->softDeletes();
		});
	}

	public function down()
	{
		Schema::drop('payment_terms');
	}
}