<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateOrderItemsTable extends Migration {

	public function up()
	{
		Schema::create('order_items', function(Blueprint $table) {
			$table->increments('id');
			$table->bigInteger('order_id')->unsigned();
			$table->string('name')->index();
			$table->string('hsn');
			$table->string('make');
			$table->smallInteger('quantity')->unsigned();
			$table->bigInteger('unit_id')->unsigned();
			$table->double('price');
			$table->smallInteger('gst');
			$table->timestamp('tat');
			$table->datetime('sales_tat');
			$table->datetime('dispatch_tat');
			$table->tinyInteger('shortage_excess');
			$table->tinyInteger('shortage_excess_type');
			$table->text('remarks');
			$table->timestamps();
			$table->softDeletes();
		});
	}

	public function down()
	{
		Schema::drop('order_items');
	}
}