<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateComponentsTable extends Migration {

	public function up()
	{
		Schema::create('components', function(Blueprint $table) {
			$table->increments('id');
			$table->string('name');
			$table->longText('description');
			$table->date('expected_start_date');
			$table->date('expected_end_date');
			$table->date('start_date');
			$table->date('end_date');
			$table->enum('status', array('Pending', 'InProgress', 'Done'));
			$table->integer('project_id')->unsigned();
			$table->integer('created_by')->unsigned();
			$table->softDeletes();
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('components');
	}
}