<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateLivesTable extends Migration {

	public function up()
	{
		Schema::create('lives', function(Blueprint $table) {
			$table->bigIncrements('id');
			$table->enum('status', array('coming', 'current', 'waiting', 'in_progress', 'closed', 'not_buyed', 'cancel_by_creator', 'cancel_by_user'));
			$table->string('cover');
			$table->string('title', 200);
			$table->text('description');
			$table->boolean('is_draft');
			$table->boolean('is_free');
			$table->float('fixed_price_token')->nullable();
			$table->integer('max_participant');
			$table->smallInteger('max_ticket_per_participant');
			$table->datetime('start_at');
			$table->datetime('end_at');
			$table->smallInteger('duration');
			$table->string('agora_token')->nullable();
			$table->bigInteger('user_id')->unsigned();
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('lives');
	}
}