<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateUserCertificationsTable extends Migration {

	public function up()
	{
		Schema::create('user_certifications', function(Blueprint $table) {
			$table->bigIncrements('id');
			$table->boolean('call_is_free')->default(1);
			$table->float('call_pricing')->nullable();
			$table->bigInteger('category_id')->unsigned();
			$table->boolean('is_active')->default(1);
			$table->bigInteger('user_id')->unsigned();
			$table->bigInteger('user_certification_request_id')->unsigned();
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('user_certifications');
	}
}