<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateAdminReportsTable extends Migration {

	public function up()
	{
		Schema::create('admin_reports', function(Blueprint $table) {
			$table->bigIncrements('id');
			$table->string('category', 100);
			$table->text('message');
			$table->bigInteger('user_message_id')->unsigned()->nullable();
			$table->bigInteger('user_review_id')->unsigned();
			$table->bigInteger('user_profil_id')->unsigned()->nullable();
			$table->bigInteger('post_comment_id')->unsigned()->nullable();
			$table->bigInteger('post_id')->unsigned()->nullable();
			$table->bigInteger('live_id')->unsigned();
			$table->bigInteger('call_id')->unsigned();
			$table->bigInteger('user_id')->unsigned();
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('admin_reports');
	}
}