<?php

class AdminReport extends Eloquent {

	protected $table = 'admin_reports';
	public $timestamps = true;

	public function user()
	{
		return $this->belongsTo('User', 'User');
	}

	public function message()
	{
		return $this->belongsTo('UserThread', 'UserMessage');
	}

	public function post_id()
	{
		return $this->belongsTo('Post', 'Post');
	}

	public function publication_comment()
	{
		return $this->belongsTo('PostComment', 'publicationComment');
	}

	public function review()
	{
		return $this->belongsTo('UserReview', 'UserReview');
	}

	public function live()
	{
		return $this->belongsTo('Live', 'Live');
	}

	public function call()
	{
		return $this->hasOne('Call', 'Call');
	}

}