<?php

class Post extends Eloquent {

	protected $table = 'posts';
	public $timestamps = true;

	public function comment()
	{
		return $this->hasMany('PostComment', 'Comment');
	}

	public function photo()
	{
		return $this->hasOne('PostPhoto', 'Photo');
	}

	public function video()
	{
		return $this->hasOne('PostVideo', 'Video');
	}

	public function like()
	{
		return $this->hasMany('PostLike', 'Like');
	}

	public function location()
	{
		return $this->hasOne('PostLocation', 'Location');
	}

	public function identify_user()
	{
		return $this->hasMany('PostIdentifyUser', 'IdentifyUser');
	}

	public function tags()
	{
		return $this->hasMany('PostTag', 'PostTag');
	}

	public function center_of_interests()
	{
		return $this->hasMany('PostCenterOfInterest', 'PostCenterOfInterest');
	}

}