<?php

class User extends Eloquent {

	protected $table = 'users';
	public $timestamps = true;

	public function push_notification()
	{
		return $this->hasOne('UserPushNotification', 'UserNotification');
	}

	public function information()
	{
		return $this->hasOne('UserInformation', 'UserInformation');
	}

	public function blacklist()
	{
		return $this->hasMany('UserBlacklist', 'UserBlacklist');
	}

	public function follow()
	{
		return $this->hasMany('UserFollow', 'UserFollow');
	}

	public function certification()
	{
		return $this->hasOne('UserCertification', 'UserCertification');
	}

	public function certification_request()
	{
		return $this->hasOne('UserCertificationRequest', 'UserCertificationRequest');
	}

	public function certification_history()
	{
		return $this->hasMany('AdminCertificationHistory', 'AdminCertificationHistory');
	}

	public function favorite()
	{
		return $this->hasMany('UserFavorite', 'UserFavorite');
	}

	public function thread()
	{
		return $this->hasMany('UserThread', 'UserThread');
	}

	public function publication()
	{
		return $this->hasMany('Post', 'Publication');
	}

	public function post_comment()
	{
		return $this->hasMany('PostComment', 'PostComment');
	}

	public function post_photo()
	{
		return $this->hasMany('PostPhoto', 'PostPhoto');
	}

	public function post_video()
	{
		return $this->hasMany('PostVideo', 'PostVideo');
	}

	public function post_like()
	{
		return $this->hasMany('PostLike', 'PostLike');
	}

	public function review()
	{
		return $this->hasMany('UserReview', 'UserReview');
	}

	public function notification()
	{
		return $this->hasMany('UserNotification', 'UserNotification');
	}

	public function follow_request()
	{
		return $this->hasMany('UserFollowRequest', 'UserFollowRequest');
	}

	public function thread_sender()
	{
		return $this->hasMany('UserThreadMessage', 'UserThreadMessage');
	}

	public function thread_recipient()
	{
		return $this->hasMany('UserThreadMessage', 'UserThreadMessage');
	}

	public function lives()
	{
		return $this->hasMany('Live', 'Live');
	}

	public function event_auctions()
	{
		return $this->hasMany('CallAuctionParticipant', 'EventAuction');
	}

	public function calls()
	{
		return $this->hasMany('Call', 'Call');
	}

	public function locale()
	{
		return $this->hasOne('Locale', 'Locale');
	}

	public function center_of_interests()
	{
		return $this->hasMany('UserCenterOfInterest', 'UserCenterOfInterest');
	}

}