<?php

class UserCertification extends Eloquent {

	protected $table = 'user_certifications';
	public $timestamps = true;

	public function certification_request()
	{
		return $this->hasOne('UserCertificationRequest', 'UserCertificationRequest');
	}

	public function certification_history()
	{
		return $this->hasMany('AdminCertificationHistory', 'AdminCertificationHistory');
	}

	public function user()
	{
		return $this->belongsTo('User', 'User');
	}

	public function category()
	{
		return $this->hasOne('Category', 'Category');
	}

}