<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateCallTicketTransactionTable extends Migration {

	public function up()
	{
		Schema::create('call_ticket_transaction', function(Blueprint $table) {
			$table->bigIncrements('id');
			$table->enum('status', array('debit', 'credit'));
			$table->float('token');
			$table->string('transaction_id')->nullable();
			$table->bigInteger('call_id')->unsigned();
			$table->bigInteger('user_id')->unsigned();
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('call_ticket_transaction');
	}
}