<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateCallsTable extends Migration {

	public function up()
	{
		Schema::create('calls', function(Blueprint $table) {
			$table->bigIncrements('id');
			$table->enum('status', array('coming', 'current', 'waiting', 'in_progress', 'closed', 'not_buyed', 'cancel_by_creator', 'cancel_by_user'));
			$table->string('cover', 100);
			$table->string('title', 150);
			$table->text('description');
			$table->boolean('is_draft')->default(1);
			$table->boolean('is_free');
			$table->boolean('is_auction');
			$table->boolean('is_fixed_price');
			$table->float('fixed_price_token')->nullable();
			$table->float('auction_token_min')->nullable();
			$table->float('auction_current_token')->nullable();
			$table->bigInteger('auction_last_bidder_id')->unsigned()->nullable();
			$table->enum('validation_type', array('auto', 'manual'))->nullable();
			$table->datetime('open_at');
			$table->datetime('close_at');
			$table->datetime('start_at');
			$table->datetime('end_at');
			$table->bigInteger('agora_token');
			$table->bigInteger('user_id')->unsigned();
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('calls');
	}
}