<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateLegalCaseServicePlansTable extends Migration {

	public function up()
	{
		Schema::create('legal_case_service_plans', function(Blueprint $table) {
			$table->increments('id');
			$table->bigInteger('legal_case_service_request_id')->unsigned();
			$table->enum('service_type', array('gas', 'internet', 'electricity'));
			$table->tinyInteger('rating')->nullable();
			$table->text('rating_note')->nullable();
			$table->enum('progress_status', array('in_progress', 'comparison_ready', 'waiting_payment', 'payment-_received', 'provider_confirmed', 'done'));
			$table->bigInteger('assignee_user_id')->index();
			$table->bigInteger('assignee_role_id')->index();
			$table->datetime('assigned_at')->nullable();
			$table->bigInteger('provider_id')->unsigned();
			$table->bigInteger('bank_id')->unsigned();
			$table->text('request_note')->nullable();
			$table->text('manager_note')->nullable();
			$table->longText('client_note')->nullable();
			$table->string('plan_name')->nullable();
			$table->string('bank_account_number')->nullable();
			$table->float('price')->nullable();
			$table->boolean('is_additional_file_needed')->nullable()->default(FALSE);
			$table->datetime('installation_date')->nullable();
			$table->boolean('is_request_price')->default(FALSE);
			$table->boolean('is_terminated')->default(FALSE);
			$table->datetime('terminated_at')->nullable();
			$table->text('termination_note')->nullable();
			$table->timestamps();
			$table->softDeletes();
		});
	}

	public function down()
	{
		Schema::drop('legal_case_service_plans');
	}
}