<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateParamProvidersTable extends Migration {

	public function up()
	{
		Schema::create('param_providers', function(Blueprint $table) {
			$table->increments('id');
			$table->enum('service_type', array('gas', 'internet', 'electricity', 'bank'))->nullable();
			$table->string('name');
			$table->string('logo_path');
			$table->string('contact_phone')->nullable();
			$table->string('contact_email')->nullable();
			$table->longText('additional_info')->nullable();
			$table->timestamps();
			$table->softDeletes();
		});
	}

	public function down()
	{
		Schema::drop('param_providers');
	}
}