<?php

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class LegalCaseServiceRequests extends Eloquent {

	protected $table = 'legal_case_service_requests';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('ref_number', 'assigned_at');
	protected $visible = array('ref_number', 'assigned_at');

	public function servicePlans()
	{
		return $this->hasMany('LegalCaseServicePlans', 'legal_case_service_request_id');
	}

	public function legalCase()
	{
		return $this->belongsTo('LegalCase', 'legal_case_id');
	}

}