<?php

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Airport extends Eloquent {

	protected $table = 'airports';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];

	public function country()
	{
		return $this->hasOne('Country');
	}

	public function city()
	{
		return $this->belongsTo('City');
	}

}