<?php

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class AncillaryOrder extends Eloquent {

	protected $table = 'ancillary_orders';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];

	public function airport()
	{
		return $this->belongsTo('User');
	}

	public function user()
	{
		return $this->belongsTo('User');
	}

	public function brandEmail()
	{
		return $this->belongsTo('BrandEmail');
	}

}