<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreatePromotionCartsTable extends Migration {

	public function up()
	{
		Schema::create('promotion_carts', function(Blueprint $table) {
			$table->increments('id');
			$table->string('reference_id')->unique();
			$table->uuid('member_id')->index();
			$table->enum('status', array('unpaid', 'paid'))->index();
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('promotion_carts');
	}
}